/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Web.UI.WebControls;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.UmlRt;
using System.Globalization;

namespace Borland.Eco.Web
{
	/// <summary>
	/// Summary description for Class.
	/// </summary>
	public class TextBoxAsAttributeBinding: EcoPropertyBinding
	{
		private TextBox textBox;
		private IProperty property;
		private string name;

		public TextBoxAsAttributeBinding(TextBox tbx, IProperty prop): base()
		{
			textBox = tbx;
			property = prop;
		}

		public TextBoxAsAttributeBinding(TextBox tbx, string name): base()
		{
			textBox = tbx;
			this.name = name;
		}

		public override void Apply()
		{
			if (property.ReadOnly)
				return;
			Type targetType = property.UmlType.ObjectType;
			if (textBox.Text == "<NULL>")
			{
				property.AsObject = null;				

			}
			else 
			{
				property.AsObject = Convert.ChangeType(textBox.Text, targetType);
			}
		}

		public override void Refresh()
		{
			object value = property.AsObject;
			
			if (value == null)
				textBox.Text  = "<NULL>";
			else	
				textBox.Text = value.ToString();
		}

		public override string AppendToFilter()
		{
			string filter = "";
			string value = textBox.Text;
			if (value.Length > 0)
				filter = "c." + name + ".regExpMatch('" + value + ".*')"; // do not localize

			return filter;
		}
	}
}
